/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/
/**
 * \file    camera.h
 *
 * \brief   camera Header File
 *
 * This header file contains the Macros definitions and Function declarations 
 * for camera application
 *
 * \author  Akhil Kumar
 *
 * \version 01,06 0ct 2016 Created.
 */
/*========================
 * Includes
 *========================
 */
 
#include "DM388_types.h"

/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
 
 
 INT32 camera_test(void *testArgs);
 TEST_STATUS camera_i2c_configuration(void *testArgs);
 TEST_STATUS lvds_configuration();
 TEST_STATUS ar0331_configuration();
 TEST_STATUS ar0331_readRegister(UINT16 reg_addr,UINT16 reg_val);
 void camera_reset_toggle(void);
 
 
 
